using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace PI.ZB.N1200.ELearning.WinForms.Competence
{                                        
    public partial class FNewCompetence : PI.FM.N000.Base.WinForms.Controls.Form
    {
        private PI.ZB.N1200.ELearning.BL.ZSBELearning _blZSBELearning = null;

        private PI.ZB.N1200.ELearning.BL.BO.Competence _newCompetence = null;

        protected PI.ZB.N1200.ELearning.BL.ZSBELearning ZSBELearning
        {
            get
            {
                if (_blZSBELearning == null)
                {
                    _blZSBELearning = new PI.ZB.N1200.ELearning.BL.ZSBELearning(this.Environment);
                }
                return _blZSBELearning;
            }
        }

        public FNewCompetence()
        {
            InitializeComponent();
        }

        public PI.ZB.N1200.ELearning.BL.BO.Competence NewCompetence
        {
            get 
            {
                if (_newCompetence == null)
                {
                    if (!String.IsNullOrEmpty(_gTextBoxName.Text))
                    {
                        _newCompetence = ZSBELearning.Competence.New(_gTextBoxName.Text.Trim());
                    }
                }

                return _newCompetence; 
            }
        }

        public new void Initialize(Gemini.Core.WinForms.Interface.IPlugIn ParentPlugIn, Gemini.Core.WinForms.Interface.IEnvironment Environment)
        {
            base.Initialize(ParentPlugIn, Environment);
        }

        private void ButtonOK_Click(object sender, EventArgs e)
        {
            bool _isValid = true;
            List<string> _listMessage = new List<string>();

            _gTextBoxName.ErrorText = null;

            if(String.IsNullOrEmpty(_gTextBoxName.Text))
            {
                _gTextBoxName.ErrorText = String.Format(Gemini.Dictionary.Text.WarningValueIsMandatory.Value, _gLabelName.PlainText);
                _listMessage.Add(String.Format(Gemini.Dictionary.Text.WarningValueIsMandatory.Value, _gLabelName.PlainText));
                _isValid = false;
            }


            if (_isValid)
            {
                DialogResult = DialogResult.OK;
                Close();
            }
            else
            {
                DialogResult = DialogResult.None;
                PI.FM.N000.Base.WinForms.Controls.FDefaultMessage _dialog = new PI.FM.N000.Base.WinForms.Controls.FDefaultMessage();
                _dialog.SetMessage = _listMessage;
                _dialog.ShowDialog();
            }
        }

        private void ButtonCancel_Click(object sender, EventArgs e)
        {
            DialogResult = DialogResult.Cancel;
            Close();
        }
    }
}